//
//  HatchOutlineFilter.h
//  HatchOutlineFilter
//
//  Created by Georg Seifert on 28.04.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSFilterPlugin.h>

@interface HatchOutlineFilter : GSFilterPlugin

@property (nonatomic, weak) IBOutlet NSTextField *originXField;
@property (nonatomic, weak) IBOutlet NSTextField *originYField;
@property (nonatomic, weak) IBOutlet NSTextField *stepWidthField;
@property (nonatomic, weak) IBOutlet NSTextField *angleField;
@property (nonatomic, weak) IBOutlet NSButton *doOffsetCheckbox;
@property (nonatomic, weak) IBOutlet NSTextField *offsetField;
@property (nonatomic, weak) IBOutlet NSButton *useBackgroundCheckbox;

- (IBAction)setOriginX:(id)sender;
- (IBAction)setOriginY:(id)sender;
- (IBAction)setStepWidth:(id)sender;
- (IBAction)setAngle:(id)sender;
- (IBAction)setDoOffset:(id)sender;
- (IBAction)setOffset:(id)sender;
- (IBAction)setUseBackground:(id)sender;

@end
